/* -LICENSE-START-
 ** Copyright (c) 2016 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 **
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 **
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */

#include "CEA708_Commands.h"
#include <cstring>

namespace CEA708
{

SyntacticElement::SyntacticElement(uint8_t len)
 : m_len(len)
{
	memset(m_buffer, 0, kMaxElementLength);
}

uint8_t SyntacticElement::operator[](uint8_t i) const
{
	return m_buffer[i];
}
uint8_t& SyntacticElement::operator[](uint8_t i)
{
	return m_buffer[i];
}

const uint8_t* SyntacticElement::data() const
{
	return m_buffer;
}
uint8_t SyntacticElement::size() const
{
	return m_len;
}

SyntacticElement Reset()
{
	SyntacticElement cmd(1);
	cmd[0] = 0x8F;
	return cmd;
}

SyntacticElement EndOfText()
{
	SyntacticElement cmd(1);
	cmd[0] = 0x03;
	return cmd;
}

SyntacticElement SetCurrentWindow(WindowID windowID)
{
	SyntacticElement cmd(1);
	cmd[0] = 0x80 + windowID;
	return cmd;
}

SyntacticElement DefineWindow(WindowID windowID, Priority priority, Anchor anchorPoint, bool relativePositioning, uint8_t anchorVertical, uint8_t anchorHorizontal, uint8_t rowCount, uint8_t columnCount, bool rowLock, bool columnLock, bool visible, WindowStyle windowStyle, PenStyle penStyle)
{
	SyntacticElement cmd(7);
	cmd[0] = 0x98 + windowID;
	cmd[1] = (visible << 5) | (rowLock << 4) | (columnLock << 3) | priority;
	cmd[2] = (relativePositioning << 7) | (anchorVertical & 0x7F);
	cmd[3] = anchorHorizontal;
	cmd[4] = (anchorPoint << 4) | (rowCount & 0xF);
	cmd[5] = columnCount & 0x3F;
	cmd[6] = ((windowStyle & 0x7) << 3) | (penStyle & 0x7);
	return cmd;
}

SyntacticElement DeleteWindows()
{
	SyntacticElement cmd(2);
	cmd[0] = 0x8C;
	cmd[1] = 0xFF;
	return cmd;
}

SyntacticElement DisplayWindows(uint8_t windowMask)
{
	SyntacticElement cmd(2);
	cmd[0] = 0x89;
	cmd[1] = windowMask;
	return cmd;
}

SyntacticElement HideWindows()
{
	SyntacticElement cmd(2);
	cmd[0] = 0x8A;
	cmd[1] = 0xFF;
	return cmd;
}

SyntacticElement SetWindowAttributes(Justify justify, PrintDirection printDirection, ScrollDirection scrollDirection, bool wordwrap, DisplayEffect displayEffect, EffectDirection effectDirection, uint8_t effectSpeed, Colour fillColour, Opacity fillOpacity, BorderType borderType, Colour borderColour)
{
	SyntacticElement cmd(5);
	cmd[0] = 0x97;
	cmd[1] = (fillOpacity << 6) | (fillColour & 0x3F);
	cmd[2] = (borderType << 6) | (borderColour & 0x3F);
	cmd[3] = ((borderType << 5) & 0x80) | (wordwrap << 6) | (printDirection << 4) | (scrollDirection << 2) | justify;
	cmd[4] = (effectSpeed << 4) | (effectDirection << 2) | displayEffect;
	return cmd;
}

SyntacticElement SetPenAttributes(PenSize penSize, Font font, TextTag textTag, TextOffset offset, bool italic, bool underline, EdgeType edgeType)
{
	SyntacticElement cmd(3);
	cmd[0] = 0x90;
	cmd[1] = (textTag << 4) | (offset << 2) | penSize;
	cmd[2] = (italic << 7) | (underline << 6) | (edgeType << 3) | font;
	return cmd;
}

SyntacticElement SetPenColour(Colour foregroundColour, Opacity foregroundOpacity, Colour backgroundColour, Opacity backgroundOpacity, Colour edgeColour)
{
	SyntacticElement cmd(4);
	cmd[0] = 0x91;
	cmd[1] = (foregroundOpacity << 6) | foregroundColour;
	cmd[2] = (backgroundOpacity << 6) | backgroundColour;
	cmd[3] = edgeColour;
	return cmd;
}

SyntacticElement SetPenLocation(uint8_t row, uint8_t column)
{
	SyntacticElement cmd(3);
	cmd[0] = 0x92;
	cmd[1] = row & 0xF;
	cmd[2] = column & 0x3F;
	return cmd;
}

}

